using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main(string[] args)
    {
        string[] firstLine = Console.ReadLine().Split();
        int N = int.Parse(firstLine[0]);
        int M = int.Parse(firstLine[1]);
        int Q = int.Parse(firstLine[2]);
        int P = int.Parse(firstLine[3]);

        int[] values = Console.ReadLine().Split().Select(int.Parse).ToArray();

        List<int>[] graph = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
            graph[i] = new List<int>();

        for (int i = 0; i < M; i++)
        {
            string[] edge = Console.ReadLine().Split();
            int u = int.Parse(edge[0]);
            int v = int.Parse(edge[1]);
            graph[u].Add(v);
            graph[v].Add(u);
        }

        int[] answers = new int[Q];
        int prevAnswer = 0;

        for (int i = 0; i < Q; i++)
        {
            string[] query = Console.ReadLine().Split();
            int a1 = int.Parse(query[0]);
            int b1 = int.Parse(query[1]);

            int a = (a1 + prevAnswer * (P - 1)) % N + 1;
            int b = (b1 + prevAnswer * (P - 1)) % N + 1;

            HashSet<int> visited = new HashSet<int>();
            List<int> pathValues = new List<int>();

            DFS(a, b, graph, values, visited, pathValues);

            pathValues.Sort();
            answers[i] = pathValues[(pathValues.Count - 1) / 2];
            prevAnswer = answers[i];
        }

        Console.WriteLine(string.Join(Environment.NewLine, answers));
    }

    static bool DFS(int current, int target, List<int>[] graph, int[] values, HashSet<int> visited, List<int> pathValues)
    {
        if (visited.Contains(current)) return false;
        visited.Add(current);
        pathValues.Add(values[current - 1]);

        if (current == target) return true;

        foreach (int neighbor in graph[current])
        {
            if (DFS(neighbor, target, graph, values, visited, pathValues))
                return true;
        }

        pathValues.RemoveAt(pathValues.Count - 1);
        return false;
    }
}